<div class="container mt-4">
    <div class="row">
    <?php
        $DETAILS = $THIS->getUserDetails();
        $userTypes = [
            0 => "Buyer",
            1 => "Owner",
            2 => "Tenant",
            3 => "Agent",
            4 => "Builder"
        ];

        // Get user_type from user details and convert it into an array
        $selectedUserTypes = isset($DETAILS[0]['user_type']) ? explode(',', trim($DETAILS[0]['user_type'], ',')) : [];
        ?>
        <div class="col-lg-12">
            <div class="card shadow-lg p-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Edit User Information</h5>
                </div>
                <div class="card-body">
                    <form action="<?=site_url('Operation/editSubmitted')?>" method="post" enctype="multipart/form-data">
                        <?= form_hidden('user_id', $DETAILS[0]['user_id']) ?>
                        
                        <div class="row">
                            <!-- Left Column -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Name</label>
                                    <input type="text" class="form-control" name="user_name" value="<?= $DETAILS[0]['user_name'] ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Contact Number</label>
                                    <input type="text" class="form-control" name="user_contact_number" value="<?= $DETAILS[0]['user_contact_number'] ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="user_email" value="<?= $DETAILS[0]['user_email'] ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">User Type</label>
                                    <select class="form-control" name="user_type" required>
                                        <?php foreach ($userTypes as $key => $value): ?>
                                            <option value="<?= $key ?>" <?= $DETAILS[0]['user_type'] == $key ? 'selected' : '' ?>><?= $value ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Date of Birth</label>
                                    <input type="date" class="form-control" name="user_dob" value="<?= $DETAILS[0]['user_dob'] ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Gender</label>
                                    <select class="form-control" name="user_gender" required>
                                        <option value="0" <?= $DETAILS[0]['user_gender'] == 0 ? 'selected' : '' ?>>Female</option>
                                        <option value="1" <?= $DETAILS[0]['user_gender'] == 1 ? 'selected' : '' ?>>Male</option>
                                        <option value="2" <?= $DETAILS[0]['user_gender'] == 2 ? 'selected' : '' ?>>Others</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Right Column -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Address</label>
                                    <textarea class="form-control" name="user_address"><?= $DETAILS[0]['user_address'] ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">City</label>
                                    <input type="text" class="form-control" name="user_city" value="<?= $DETAILS[0]['user_city'] ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">State</label>
                                    <input type="text" class="form-control" name="user_state" value="<?= $DETAILS[0]['user_state'] ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Country</label>
                                    <input type="text" class="form-control" name="user_country" value="<?= $DETAILS[0]['user_country'] ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Pin Code</label>
                                    <input type="text" class="form-control" name="user_pin" value="<?= $DETAILS[0]['user_pin'] ?>">
                                </div>
                                
                                <!-- Profile Picture -->
                                <div class="mb-3">
                                    <label class="form-label">Profile Picture</label>
                                    <div class="input-group">
                                        <input type="file" class="form-control" name="user_profile_picture" id="profilePictureInput" onchange="previewImage(event)">
                                    </div>
                                    <div class="mt-2">
                                        <img id="profilePicturePreview" src="<?= file_upload_base_url($DETAILS[0]['user_profile_picture'] ?? 'default.png') ?>" class="rounded border" width="100" height="100" style="object-fit: cover;">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="form-control" name="IsDel">
                                        <option value="0" <?= $DETAILS[0]['IsDel'] == 0 ? 'selected' : '' ?>>Not Deleted</option>
                                        <option value="1" <?= $DETAILS[0]['IsDel'] == 1 ? 'selected' : '' ?>>Deleted</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-end mt-4">
                            <button type="reset" class="btn btn-secondary me-2"><i class="fa fa-refresh"></i> Reset</button>
                            <button type="submit" class="btn btn-primary" name="submit" value="submit">
                                <i class="fa fa-check"></i> Update
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


