<div class="container mt-4">
    <div class="row">
        <!-- Profile Card -->
        <?php
        $DETAILS = $THIS->getUserDetails();
        $userTypes = [
            0 => "Buyer",
            1 => "Owner",
            2 => "Tenant",
            3 => "Agent",
            4 => "Builder"
        ];

        // Get user_type from user details and convert it into an array
        $selectedUserTypes = isset($DETAILS[0]['user_type']) ? explode(',', trim($DETAILS[0]['user_type'], ',')) : [];
        ?>
        <div class="col-lg-3 col-md-12">
            <div class="card text-center shadow-lg p-3">
                <div class="card-body">
                    <img src="<?= file_upload_base_url($DETAILS[0]['user_profile_picture'] ?? 'default.png'); ?>" class="rounded-circle img-fluid mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                    <h4 class="card-title"><?= $DETAILS[0]['user_name'] ?? 'N/A'; ?></h4>
                    <p class="text-muted">User</p>
                    <div class="profile-usermenu">
                        <ul class="list-unstyled">
                            <li>
                                <a href="<?=site_url('profile-details-page');?>">
                                    <i class="icon-home"></i> Overview </a>
                            </li>
                            <li>
                                <a href="<?=site_url('edit-profile-page');?>">
                                    <i class="icon-settings"></i> Edit Profile </a>
                            </li>
                        </ul>
                    </div>
                    <hr>
                    <p class="fw-bold mb-1">User Type</p>
                    <p class="text-muted">
                        <?php
                        if (!empty($selectedUserTypes)) {
                            $types = array_map(function ($type) use ($userTypes) {
                                return $userTypes[$type] ?? null;
                            }, $selectedUserTypes);
                            echo implode(', ', array_filter($types));
                        } else {
                            echo "N/A";
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Personal Info Card -->
        <div class="col-lg-5 col-md-6">
            <div class="card shadow-lg p-3">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Personal Information</h5>
                </div>
                <div class="card-body">
                    <p><strong>Name:</strong> <?= $DETAILS[0]['user_name'] ?? 'N/A'; ?></p>
                    <p><strong>Date of Birth:</strong> <?= $DETAILS[0]['user_dob'] ?? 'N/A'; ?></p>
                    <p><strong>Gender:</strong>
                        <?php
                        if ($DETAILS[0]['user_gender'] == 0) echo "Female";
                        if ($DETAILS[0]['user_gender'] == 1) echo "Male";
                        if ($DETAILS[0]['user_gender'] == 2) echo "Others"; ?>
                    </p>
                    <p><strong>Address:</strong> <?= $DETAILS[0]['user_address'] ?? 'N/A'; ?></p>
                    <p><strong>City:</strong> <?= $DETAILS[0]['user_city'] ?? 'N/A'; ?></p>
                    <p><strong>State:</strong> <?= $DETAILS[0]['user_state'] ?? 'N/A'; ?></p>
                    <p><strong>Country:</strong> <?= $DETAILS[0]['user_country'] ?? 'N/A'; ?></p>
                    <p><strong>PIN Code:</strong> <?= $DETAILS[0]['user_pin'] ?? 'N/A'; ?></p>
                </div>
            </div>
        </div>

        <!-- Contact Info Card -->
        <div class="col-lg-4 col-md-6">
            <div class="card shadow-lg p-3">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Contact Information</h5>
                </div>
                <div class="card-body">
                    <p><strong>Email:</strong> <?= $DETAILS[0]['user_email'] ?? 'N/A'; ?></p>
                    <p><strong>Contact Number:</strong> <?= $DETAILS[0]['user_contact_number'] ?? 'N/A'; ?></p>
                </div>
            </div>
        </div>
    </div>
</div>